 DATAPACKAGE: ENERGY EFFICIENCY DATABASE FOR SWISS INDUSTRY
===========================================================================

Package Version: 2021-01-20


Geographical scope and resolution
===========================================================================
* Scope: Industrial sectors in Switzerland
* Resolution: National


Temporal scope and resolution
===========================================================================
* Scope: 2020
* Resolution: 1 year


Version history
===========================================================================
* 2021-01-20 Not documented


Resources
===========================================================================
[Package description page](http://sweet-cross.ch/data/energy-efficiency-industry-unige/2021-01-20/)[ZIP Package](http://sweet-cross.ch/data/energy-efficiency-industry-unige/cross-energy-efficiency-industry-unige-2021-01-20.zip

Sources
===========================================================================
* [Zuberi MJS, Patel MK. Cost-effectiveness analysis of energy efficiency measures in the Swiss chemical and pharmaceutical industry. International Journal of Energy Research (2019) 43(1), 313-336, doi: 10.1002/er.4267.](https://doi.org/10.1002/er.4267)
* [Zuberi MJS, Bless F, Chambers J, Arpagaus C, Bertsch S, Patel MK. Excess heat recovery: An invisible energy resource for the Swiss industry sector. Applied Energy (2018) 228, 390-408, doi: 10.1016/j.apenergy.2018.06.070.](https://doi.org/10.1016/j.apenergy.2018.06.070)
* [Zuberi MJS, Tijdink A, Patel MK. Techno-economic analysis of energy efficiency improvement in electric motor driven systems in Swiss industry. Applied Energy (2017) 205, 85-104, doi: 10.1016/j.apenergy.2017.07.121.](https://doi.org/10.1016/j.apenergy.2017.07.121)
* [Zuberi MJS, Patel MK. Bottom-up analysis of energy efficiency improvement and CO2 emission reduction potentials in the Swiss cement industry. Journal of Cleaner Production (2017) 142, 4294-4309, doi: 10.1016/j.jclepro.2016.11.178.](https://doi.org/10.1016/j.jclepro.2016.11.178)


Field documentation
===========================================================================
energy-efficiency-industry-overview.csv---------------------------------------------------------------------------* measure_title
- Type: string
- Description: Short title of the EE measure* measure_id
- Type: string
- Description: EE measure identifier* sector
- Type: string
- Description: Industrial sector in which the EE measure is applicable* noga_code
- Type: string
- Description: Identifier for an industrial sector representing the classified Swiss economic acitivity* name_of_process_system
- Type: string
- Description: Sub-system/processes within an industrial sector* diff_%
- Type: number
- Description: Cuurent level of an EE measure implementation [%]* tech_max_diff_%
- Type: number
- Description: Maximum potential of an EE measure implementation [%]* absol_elec_savings_poten _gj_per_a
- Type: number
- Description: Measure specific annual electricity savings potential [GJ]* absol_fuel_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual fuel savings potential [GJ]* absol_final_en_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual final energy savings potential [GJ]* rel_elec_savings_poten_%
- Type: number
- Description: Measure specific annual electricity savings potential in relative terms [%]* rel_fuel_savings_poten_%
- Type: number
- Description: Measure specific annual fuel savings potential in relative terms [%]* absol_co_abat_t_per_a
- Type: number
- Description: Measure specific annual CO2 savings potential [t]* rel_co_abat_%
- Type: number
- Description: Measure specific annual CO2 savings potential in relative terms [%]* tot_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Total annual investment costs per unit of energy saved in a year [CHF/GJ]* en_rel_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Energy relevant investment costs per unit of energy saved in a year [CHF/GJ]* change_om_costs_chf_per_gj
- Type: number
- Description: Change in annual operation and maintenance costs per unit of energy saved [CHF/GJ]* lifetime_years
- Type: number
- Description: Measure lifetime [years]* non_en_benefits_descrip
- Type: string
- Description: Description of the non-energy benefits* measure_type
- Type: string
- Description: What type of measure is it: New production equipment - N, Retrofit - R,  Good Housekeeping - G or Closure - C?* measure_category
- Type: string
- Description: 1) Good housekeeping; 2) Process control and management; 3) Reduction of heat losses through surfaces; 4) Process integration (e.g by pinch or exergy an.); 5) Other heat recovery techniques; 6) Energy recovery other than heat; 7) Improved lighting systems; 8) Reduction of friction losses during movement; 9) More efficient conv. of electr. into movement; 10) New process technologies; 11) More efficient furnaces and burners; 12) More efficient conv. of fuel into work; 13) Renewable energy and heat from waste; 14) Power generation from excess heat; 15) Fuel shift* competing_measures
- Type: string
- Description: EE measures that directly conflict with one another* documentation
- Type: string
- Description: Relevant publication* other_remarks
- Type: string
- Description: Other remarksenergy-efficiency-cement-industry.csv---------------------------------------------------------------------------* measure_title
- Type: string
- Description: Short title of the EE measure* measure_id
- Type: string
- Description: EE measure identifier* sector
- Type: string
- Description: Industrial sector in which the EE measure is applicable* noga_code
- Type: string
- Description: Identifier for an industrial sector representing the classified Swiss economic acitivity* name_of_process_system
- Type: string
- Description: Sub-system/processes within an industrial sector* diff_%
- Type: number
- Description: Cuurent level of an EE measure implementation [%]* tech_max_diff_%
- Type: number
- Description: Maximum potential of an EE measure implementation [%]* absol_elec_savings_poten _gj_per_a
- Type: number
- Description: Measure specific annual electricity savings potential [GJ]* absol_fuel_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual fuel savings potential [GJ]* absol_final_en_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual final energy savings potential [GJ]* rel_elec_savings_poten_%
- Type: number
- Description: Measure specific annual electricity savings potential in relative terms [%]* rel_fuel_savings_poten_%
- Type: number
- Description: Measure specific annual fuel savings potential in relative terms [%]* absol_co_abat_t_per_a
- Type: number
- Description: Measure specific annual CO2 savings potential [t]* rel_co_abat_%
- Type: number
- Description: Measure specific annual CO2 savings potential in relative terms [%]* tot_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Total annual investment costs per unit of energy saved in a year [CHF/GJ]* en_rel_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Energy relevant investment costs per unit of energy saved in a year [CHF/GJ]* change_om_costs_chf_per_gj
- Type: number
- Description: Change in annual operation and maintenance costs per unit of energy saved [CHF/GJ]* lifetime_years
- Type: number
- Description: Measure lifetime [years]* non_en_benefits_descrip
- Type: string
- Description: Description of the non-energy benefits* measure_type
- Type: string
- Description: What type of measure is it: New production equipment - N, Retrofit - R,  Good Housekeeping - G or Closure - C?* measure_category
- Type: string
- Description: 1) Good housekeeping; 2) Process control and management; 3) Reduction of heat losses through surfaces; 4) Process integration (e.g by pinch or exergy an.); 5) Other heat recovery techniques; 6) Energy recovery other than heat; 7) Improved lighting systems; 8) Reduction of friction losses during movement; 9) More efficient conv. of electr. into movement; 10) New process technologies; 11) More efficient furnaces and burners; 12) More efficient conv. of fuel into work; 13) Renewable energy and heat from waste; 14) Power generation from excess heat; 15) Fuel shift* competing_measures
- Type: string
- Description: EE measures that directly conflict with one another* documentation
- Type: string
- Description: Relevant publication* other_remarks
- Type: string
- Description: Other remarksenergy-efficiency-chemical-industry.csv---------------------------------------------------------------------------* measure_title
- Type: string
- Description: Short title of the EE measure* measure_id
- Type: string
- Description: EE measure identifier* sector
- Type: string
- Description: Industrial sector in which the EE measure is applicable* noga_code
- Type: string
- Description: Identifier for an industrial sector representing the classified Swiss economic acitivity* name_of_process_system
- Type: string
- Description: Sub-system/processes within an industrial sector* diff_%
- Type: number
- Description: Cuurent level of an EE measure implementation [%]* tech_max_diff_%
- Type: number
- Description: Maximum potential of an EE measure implementation [%]* absol_elec_savings_poten _gj_per_a
- Type: number
- Description: Measure specific annual electricity savings potential [GJ]* absol_fuel_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual fuel savings potential [GJ]* absol_final_en_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual final energy savings potential [GJ]* rel_elec_savings_poten_%
- Type: number
- Description: Measure specific annual electricity savings potential in relative terms [%]* rel_fuel_savings_poten_%
- Type: number
- Description: Measure specific annual fuel savings potential in relative terms [%]* absol_co_abat_t_per_a
- Type: number
- Description: Measure specific annual CO2 savings potential [t]* rel_co_abat_%
- Type: number
- Description: Measure specific annual CO2 savings potential in relative terms [%]* tot_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Total annual investment costs per unit of energy saved in a year [CHF/GJ]* en_rel_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Energy relevant investment costs per unit of energy saved in a year [CHF/GJ]* change_om_costs_chf_per_gj
- Type: number
- Description: Change in annual operation and maintenance costs per unit of energy saved [CHF/GJ]* lifetime_years
- Type: number
- Description: Measure lifetime [years]* non_en_benefits_descrip
- Type: string
- Description: Description of the non-energy benefits* measure_type
- Type: string
- Description: What type of measure is it: New production equipment - N, Retrofit - R,  Good Housekeeping - G or Closure - C?* measure_category
- Type: string
- Description: 1) Good housekeeping; 2) Process control and management; 3) Reduction of heat losses through surfaces; 4) Process integration (e.g by pinch or exergy an.); 5) Other heat recovery techniques; 6) Energy recovery other than heat; 7) Improved lighting systems; 8) Reduction of friction losses during movement; 9) More efficient conv. of electr. into movement; 10) New process technologies; 11) More efficient furnaces and burners; 12) More efficient conv. of fuel into work; 13) Renewable energy and heat from waste; 14) Power generation from excess heat; 15) Fuel shift* competing_measures
- Type: string
- Description: EE measures that directly conflict with one another* documentation
- Type: string
- Description: Relevant publication* other_remarks
- Type: string
- Description: Other remarksenergy-efficiency-excess-heat.csv---------------------------------------------------------------------------* measure_title
- Type: string
- Description: Short title of the EE measure* measure_id
- Type: string
- Description: EE measure identifier* sector
- Type: string
- Description: Industrial sector in which the EE measure is applicable* noga_code
- Type: string
- Description: Identifier for an industrial sector representing the classified Swiss economic acitivity* name_of_process_system
- Type: string
- Description: Sub-system/processes within an industrial sector* diff_%
- Type: number
- Description: Cuurent level of an EE measure implementation [%]* tech_max_diff_%
- Type: number
- Description: Maximum potential of an EE measure implementation [%]* absol_elec_savings_poten _gj_per_a
- Type: number
- Description: Measure specific annual electricity savings potential [GJ]* absol_fuel_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual fuel savings potential [GJ]* absol_final_en_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual final energy savings potential [GJ]* rel_elec_savings_poten_%
- Type: number
- Description: Measure specific annual electricity savings potential in relative terms [%]* rel_fuel_savings_poten_%
- Type: number
- Description: Measure specific annual fuel savings potential in relative terms [%]* absol_co_abat_t_per_a
- Type: number
- Description: Measure specific annual CO2 savings potential [t]* rel_co_abat_%
- Type: number
- Description: Measure specific annual CO2 savings potential in relative terms [%]* tot_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Total annual investment costs per unit of energy saved in a year [CHF/GJ]* en_rel_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Energy relevant investment costs per unit of energy saved in a year [CHF/GJ]* change_om_costs_chf_per_gj
- Type: number
- Description: Change in annual operation and maintenance costs per unit of energy saved [CHF/GJ]* lifetime_years
- Type: number
- Description: Measure lifetime [years]* non_en_benefits_descrip
- Type: string
- Description: Description of the non-energy benefits* measure_type
- Type: string
- Description: What type of measure is it: New production equipment - N, Retrofit - R,  Good Housekeeping - G or Closure - C?* measure_category
- Type: string
- Description: 1) Good housekeeping; 2) Process control and management; 3) Reduction of heat losses through surfaces; 4) Process integration (e.g by pinch or exergy an.); 5) Other heat recovery techniques; 6) Energy recovery other than heat; 7) Improved lighting systems; 8) Reduction of friction losses during movement; 9) More efficient conv. of electr. into movement; 10) New process technologies; 11) More efficient furnaces and burners; 12) More efficient conv. of fuel into work; 13) Renewable energy and heat from waste; 14) Power generation from excess heat; 15) Fuel shift* competing_measures
- Type: string
- Description: EE measures that directly conflict with one another* documentation
- Type: string
- Description: Relevant publication* other_remarks
- Type: string
- Description: Other remarksenergy-efficiency-motor-systems.csv---------------------------------------------------------------------------* measure_title
- Type: string
- Description: Short title of the EE measure* measure_id
- Type: string
- Description: EE measure identifier* sector
- Type: string
- Description: Industrial sector in which the EE measure is applicable* noga_code
- Type: string
- Description: Identifier for an industrial sector representing the classified Swiss economic acitivity* name_of_process_system
- Type: string
- Description: Sub-system/processes within an industrial sector* diff_%
- Type: number
- Description: Cuurent level of an EE measure implementation [%]* tech_max_diff_%
- Type: number
- Description: Maximum potential of an EE measure implementation [%]* absol_elec_savings_poten _gj_per_a
- Type: number
- Description: Measure specific annual electricity savings potential [GJ]* absol_fuel_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual fuel savings potential [GJ]* absol_final_en_savings_poten_gj_per_a
- Type: number
- Description: Measure specific annual final energy savings potential [GJ]* rel_elec_savings_poten_%
- Type: number
- Description: Measure specific annual electricity savings potential in relative terms [%]* rel_fuel_savings_poten_%
- Type: number
- Description: Measure specific annual fuel savings potential in relative terms [%]* absol_co_abat_t_per_a
- Type: number
- Description: Measure specific annual CO2 savings potential [t]* rel_co_abat_%
- Type: number
- Description: Measure specific annual CO2 savings potential in relative terms [%]* tot_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Total annual investment costs per unit of energy saved in a year [CHF/GJ]* en_rel_invest_cost_ratio_chf_per_gj_per_a
- Type: number
- Description: Energy relevant investment costs per unit of energy saved in a year [CHF/GJ]* change_om_costs_chf_per_gj
- Type: number
- Description: Change in annual operation and maintenance costs per unit of energy saved [CHF/GJ]* lifetime_years
- Type: number
- Description: Measure lifetime [years]* non_en_benefits_descrip
- Type: string
- Description: Description of the non-energy benefits* measure_type
- Type: string
- Description: What type of measure is it: New production equipment - N, Retrofit - R,  Good Housekeeping - G or Closure - C?* measure_category
- Type: string
- Description: 1) Good housekeeping; 2) Process control and management; 3) Reduction of heat losses through surfaces; 4) Process integration (e.g by pinch or exergy an.); 5) Other heat recovery techniques; 6) Energy recovery other than heat; 7) Improved lighting systems; 8) Reduction of friction losses during movement; 9) More efficient conv. of electr. into movement; 10) New process technologies; 11) More efficient furnaces and burners; 12) More efficient conv. of fuel into work; 13) Renewable energy and heat from waste; 14) Power generation from excess heat; 15) Fuel shift* competing_measures
- Type: string
- Description: EE measures that directly conflict with one another* documentation
- Type: string
- Description: Relevant publication* other_remarks
- Type: string
- Description: Other remarks

We follow the Data Package standard by the Frictionless Data project, a
part of the Open Knowledge Foundation: http://frictionlessdata.io/

License and attribution
===========================================================================
Data license: 
    [Creative Commons Attribution 4.0](https://creativecommons.org/licenses/by/4.0/)
Attribution:

Feedback
===========================================================================
Thank you for using data provided by CROSSDat. If you have any question or feedback, please do not hesitate to contact us.

For this data package, contact: 
Jibran <Jibran.Zuberi@unige.ch>
Martin <martin.patel@unige.ch>
For general issues, find our team contact details on our website: http://sweet-cross.ch













we are here