 DATAPACKAGE: ENERGY EFFICIENCY INVESTMENT COST CURVE FOR ENVELOPE MEASURES IN RESIDENTIAL BUILDING STOCK (SWISSRES MODEL)
===========================================================================

Package Version: 2020-05-06


Geographical scope and resolution
===========================================================================
* Scope: Residential sector in Switzerland
* Resolution: Buildings


Temporal scope and resolution
===========================================================================
* Scope: 2016
* Resolution: 1 year


Version history
===========================================================================
* 2020-05-06 Not documented


Resources
===========================================================================
[Package description page](http://sweet-cross.ch/data/energy-efficiency-residential-swissres/2020-05-06/)[ZIP Package](http://sweet-cross.ch/data/energy-efficiency-residential-swissres/cross-energy-efficiency-residential-swissres-2020-05-06.zip

Sources
===========================================================================
* [Streicher, K.N., Parra, D., Buerer, M.C., Patel, M.K., 2017. Techno-economic potential of large-scale energy retrofit in the Swiss residential building stock. Energy Procedia, CISBAT 2017 International Conference Future Buildings & Districts – Energy Efficiency from Nano to Urban Scale 122, 121–126.](https://doi.org/10.1016/j.egypro.2017.07.314)
* [K.N. Streicher, P. Padey, D. Parra, M.C. Bürer, M.K. Patel, Assessment of the current thermal performance level of the Swiss residential building stock: Statistical analysis of energy performance certificates, Energy Build. 178 (2018) 360–378.](https://doi.org/10.1016/j.enbuild.2018.08.032)
* [K.N. Streicher, P. Padey, D. Parra, M.C. Bürer, S. Schneider, M.K. Patel, Analysis of space heating demand in the Swiss residential building stock: Element-based bottom-up model of archetype buildings, Energy Build. 184 (2019) 300–322](https://doi.org/10.1016/j.enbuild.2018.12.011)
* [K.N. Streicher, S. Mennel, J. Chambers, D. Parra, M.K. Patel, Cost-effectiveness of large-scale deep energy retrofit packages for residential buildings under different economic assessment approaches, Energy and Buildings 215 (2020) 109870](https://doi.org/10.1016/j.enbuild.2020.109870)
* [T. Schluck, K.N. Streicher, S. Mennel (2019), Statistical modelling of the energy reference area based on the Swiss building stock, J. Phys.: Conf. Ser. 1343, 012031.](https://doi.org/10.1088/1742-6596/1343/1/012031)


Field documentation
===========================================================================
envelope_investment_curve_unige_2020-05-06.csv---------------------------------------------------------------------------* measure
- Type: string
- Description: Scenario: Improve, depreciation or full (based on Streicher et al (2020)) * age
- Type: number
- Description: Construction period of building 1945=Before 1945, 1950=1946-1960, 1960=1961-1970, 1970=1971-1980, 1980=1981-1990, 1990=1991-2000* buildingtype
- Type: string
- Description: Building type MFH=Multi-family house, SFH=Single-family house* typology
- Type: string
- Description: Urban-rural typology based on commune level Urban, Suburban, Rural* canton
- Type: string
- Description: Swiss Cantons abbreviation: http://swiss-government-politics.all-about-switzerland.info/swiss-federal-states-cantons.html* cost_investment__mio_chf
- Type: number
- Description: Total investment cost [Mchf]* savings_final_energy__gwh
- Type: number
- Description: Total final energy savings [GWh]* era__m2
- Type: number
- Description: Energy reference area (heated area) of building archetype in Swiss building stock [m2] in 2016 from calculated in Schluck (2019) * finalenergy__gwh
- Type: number
- Description: Total final energy demand in 2016 including the environmental heat [GWh]* primaryenergy__gwh
- Type: number
- Description: Total primary energy demand in 2016 [GWh]* usefulenergy__gwh
- Type: number
- Description: Total useful energy demand in 2016 [GWh]* cost_per_saving__chf_per_mwh
- Type: number
- Description: Costs per savings [CHF/MWh]* cost_investment_cumulated__mio_chf
- Type: number
- Description: Cummulative investment costs [MCHF]* savings_energy_cumulated__gwh
- Type: number
- Description: Cummulative energy savings [GWh]

We follow the Data Package standard by the Frictionless Data project, a
part of the Open Knowledge Foundation: http://frictionlessdata.io/

License and attribution
===========================================================================
Data license: 
    [Creative Commons Attribution 4.0](https://creativecommons.org/licenses/by/4.0/)
Attribution:

Feedback
===========================================================================
Thank you for using data provided by CROSSDat. If you have any question or feedback, please do not hesitate to contact us.

For this data package, contact: 
Kai Nino <kai.streicher@unige.ch>
Martin <martin.patel@unige.ch>
For general issues, find our team contact details on our website: http://sweet-cross.ch













we are here